﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Zestawienie obrotów i sald</title>
    <script runat="server">
    ObrotyKontaWorker okw = null;

    
    void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
         {
      ZapisKsiegowy z = (ZapisKsiegowy)args.Row;
      colWinienOperacji.EditValue =      (z.Winien.Symbol==z.WinienOperacji.Symbol && z.Winien==z.WinienOperacji) ?    "" : z.WinienOperacji.ToString();
      colMaOperacji.EditValue =  (z.Ma.Symbol==z.MaOperacji.Symbol && z.Ma==z.MaOperacji) ?   "" : z.MaOperacji.ToString();        
    }

    
    void ObrotyKonta_OnLoad(Object sender, EventArgs args)
      {
           KontoBase k  = (KontoBase)DataContext1.Get(typeof(KontoBase));

      okw = new ObrotyKontaWorker();
      ObrotyKontaWorker.Params p  = (ObrotyKontaWorker.Params)DataContext1.Get(typeof(ObrotyKontaWorker.Params));
      p.ObrotyStatusRozliczenia = ZapisyKsiegowe.Params.WgStatusuRozliczenia.Wszystkie;

      OkresObrachunkowy o         = (OkresObrachunkowy)DataContext1.Get(typeof(OkresObrachunkowy));
      okw.Param = p;
        
      
      ReportHeader1.Title =  String.Format(ReportHeader1.Title, o, k, p.Okres, p.Bufor ? "Tak" : "Nie", p.DekretyZamkniecia ? "Tak" : "Nie");

          labelSymbol.EditValue = k.Symbol;
          labelNazwa.EditValue = k.Nazwa;
          labelWaluta.EditValue = k.Waluta;
          okw.Konto = k;
          Grid1.DataSource = okw.Obroty;
      
          labelBOWn.EditValue = okw.BOWn;
          labelBOMa.EditValue = okw.BOMa;     
          labelSaldoBO.EditValue = okw.SaldoBO;           
      
          labelObrotyWn.EditValue = okw.ObrotyWn;
          labelObrotyMa.EditValue = okw.ObrotyMa;      
      
          labelObrotyNWn.EditValue = okw.ObrotyNWn;
          labelObrotyNMa.EditValue = okw.ObrotyNMa;
          labelSaldoWn.EditValue = okw.SaldoWn;
          labelSaldoMa.EditValue = okw.SaldoMa;      
          labelPersaldo.EditValue = okw.PerSaldo;
    }

    Params param = null;
    [Context]
    public Params Param {
        set { param = value; }
    }

    public class Params : ContextBase{
        public Params(Context cx)
            : base(cx) {
        }

         public ObrotyKontaWorker.Params.TypDziennika TypDziennika {
            get{ return ((ObrotyKontaWorker.Params)Context[typeof(ObrotyKontaWorker.Params)]).ObrotyTypDziennika; }
            set { ((ObrotyKontaWorker.Params)Context[typeof(ObrotyKontaWorker.Params)]).ObrotyTypDziennika = value; OnChanged(EventArgs.Empty); }
        }
    }   
    </script>

</head>
<body>
    <form id="ObrotyKonta" method="post" onload="ObrotyKonta_OnLoad" runat="server" >
        <ea:datacontext id="DataContext1" runat="server"  typename="Soneta.Ksiega.KontoBase,Soneta.Ksiega" />
        <cc1:reportheader id="ReportHeader1" title="Obroty konta|Okres obrachunkowy: {0}|Konto: {1}|Okres: {2} | Uwzględniać bufor: {3} | Uwzględniać dekrety zamknięcia: {4}" runat="server" />


        <ea:sectionmarker id="SectionMarker1" runat="server" sectiontype="Body"></ea:sectionmarker>
        <table width="100%" style="font-size: x-small; font-family: Tahoma">
            <tr>
                <td align="left">
                    <ea:datalabel id="labelSymbol" runat="server" font-names="Tahoma" encodehtml="true"></ea:datalabel>
                </td>
                <td align="middle">
                    <ea:datalabel id="labelNazwa" runat="server" font-names="Tahoma" encodehtml="true"></ea:datalabel>
                </td>
                <td align="right">
                    <ea:datalabel id="labelWaluta" runat="server" font-names="Tahoma"></ea:datalabel>
                </td>
            </tr>
        </table>
        <hr noshade="true" size="1">
        <ea:sectionmarker id="SectionMarker2" runat="server" sectiontype="Body"></ea:sectionmarker>
        <ea:grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow" sort="Dekret.Data,Dekret.Numer.Symbol,Dekret.ID,Lp" rowtypename="Soneta.Ksiega.ZapisKsiegowy,Soneta.Ksiega" rowsinrow="2" _showpagesum="True" showagrsum="True" showprevagrsum="InFooter">
            <Columns>
              <ea:GridColumn Width="20" DataMember="Numer"  ID="colNumer"></ea:GridColumn>
              <ea:GridColumn Width="20" Align="Center" DataMember="Data"  ID="colData"></ea:GridColumn>
              <ea:GridColumn Width="20" DataMember="NumerEwidencji" Caption="Nr ewidencji"  ID="colNrEwidencji"></ea:GridColumn>
              <ea:GridColumn Width="20" DataMember="NumerDokumentu" Caption="Nr dokumentu"  ID="colNrDokumentu" EncodeHTML="true"></ea:GridColumn>
              <ea:GridColumn DataMember="Konto.Symbol" Total="Info" Caption="Konto"  ID="colSymbol" EncodeHTML="true" ></ea:GridColumn>
              <ea:GridColumn DataMember="Opis" ID="colOpis" EncodeHTML="true" ></ea:GridColumn>
              <ea:GridColumn Width="20" Align="Right" DataMember="Winien.Value" Total="Sum" Caption="Winien"  HideZero="True" Format="{0:n}" ID="colWinien"></ea:GridColumn>
              <ea:GridColumn Width="20" Align="Right" Caption="Winien operacji"  ID="colWinienOperacji"></ea:GridColumn>
              <ea:GridColumn Width="20" Align="Right" DataMember="Ma.Value" Total="Sum" Caption="Ma"  HideZero="True" Format="{0:n}" ID="colMa"></ea:GridColumn>
              <ea:GridColumn Width="20" Align="Right" Caption="Ma operacji"  ID="colMaOperacji"></ea:GridColumn>
            </Columns>
          </ea:grid>
        <ea:sectionmarker id="Sectionmarker3" runat="server" sectiontype="Body"></ea:sectionmarker>

        <hr noshade="true" size="1" />

        <table style="font-size: xx-small; font-family: Tahoma" width="100%" border="1" cellspacing="0">
            <col align="left" />
            <col align="right" />
            <col align="right" />
            <col align="right" />
            <col align="right" />
            <tr>
                <td></td>
                <td align="middle">BO</td>
                <td align="middle">Obroty</td>
                <td align="middle">Obroty narastająco</td>
                <td align="middle">Saldo</td>
            </tr>
            <tr>
                <td>Winien</td>
                <td>
                    <ea:datalabel id="labelBOWn" runat="server" format="{0:n}"></ea:datalabel>
                </td>
                <td>
                    <ea:datalabel id="labelObrotyWn" runat="server" format="{0:n}"></ea:datalabel>
                </td>
                <td>
                    <ea:datalabel id="labelObrotyNWn" runat="server" format="{0:n}"></ea:datalabel>
                </td>
                <td>
                    <ea:datalabel id="labelSaldoWn" runat="server" format="{0:n}"></ea:datalabel>
                </td>
            </tr>
            <tr>
                <td>Ma</td>
                <td>
                    <ea:datalabel id="labelBOMa" runat="server" format="{0:n}"></ea:datalabel>
                </td>
                <td>
                    <ea:datalabel id="labelObrotyMa" runat="server" format="{0:n}"></ea:datalabel>
                </td>
                <td>
                    <ea:datalabel id="labelObrotyNMa" runat="server" format="{0:n}"></ea:datalabel>
                </td>
                <td>
                    <ea:datalabel id="labelSaldoMa" runat="server" format="{0:n}"></ea:datalabel>
                </td>
            </tr>
            <tr>
                <td>Persaldo</td>
                <td>
                    <ea:datalabel id="labelSaldoBO" runat="server" format="{0:n}"></ea:datalabel>
                </td>
                <td></td>
                <td></td>
                <td>
                    <ea:datalabel id="labelPersaldo" runat="server" format="{0:n}"></ea:datalabel>
                </td>
            </tr>
        </table>


        <cc1:reportfooter id="ReportFooter1" runat="server">
        <Subtitles>
          <cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
        </Subtitles>
      </cc1:reportfooter>
    </form>
</body>
</html>

